<?php

	require dirname(__FILE__)."/php/csrf.php";
	$new_token = new CSRF('booking');

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Reservation Request</title>

	<!-- Your META here -->
	<meta content="width=device-width, initial-scale=1.0, minimum-scale=1.0" name="viewport">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="css/b-check-demo.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/b-check-style.css">
	<link rel="stylesheet" href="css/colors/blue.css">

	<!-- Scripts -->
	<script src="js/jquery-1.11.1.min.js"></script>
	<script src="js/jquery-form.min.js"></script>
	<script src="js/jquery-ui.min.js"></script>
	<script src="js/jquery.maskedinput.min.js"></script>
	<script src="js/b-check-form-field.js"></script>

	<!--[if lt IE 10]>
			<script src="js/jquery.placeholder.min.js"></script>
		<![endif]-->

</head>
<body class="blue">
	<div class="b-check wrapper-wide">
		<div class="b-row">
			<header><a href="http://www.restaurantsuhring.com"><img alt="Sühring" src="http://www.restaurantsuhring.com/img/logo-dark.png" class="logo"></a><BR/>RESERVATION INQUIRY<br/><br/><p>Opening Hours:<br/>Mon-Sun:<br/>	
6:00 pm - 10:00 pm</p></header>
           
		</div>

		<div class="hr"></div>

		<form action="php/action.php" id="b-check-form" name="b-check-form" method="post" enctype="multipart/form-data" novalidate>

			<!-- start response from server -->
			<div class="b-row">
				<div id="response"></div>
			</div><!-- end response from server -->

			<!-- start token -->
			<div class="b-row">
				<?php echo $new_token->get_token(); ?>
			</div>
			<!-- end token -->

			<!-- start name  -->
			<div class="b-row">
				<label class="label">Your Name and Surname</label>
				<div class="span12">
					<div class="field checking check">
						<i class="fa fa-user icon-left"></i>
						<input type="text" name="name" placeholder="Your name">
					</div>
				</div>
			</div>
			<!-- end name -->

			<!-- start email phone-->
			<div class="b-row">
				<div class="span6">
					<label class="label">Email Address</label>
					<div class="field checking check">
						<i class="fa fa-envelope-o icon-left"></i>
						<input type="text" name="email" placeholder="Email address">
					</div>
				</div>
				<div class="span6">
					<label class="label">Phone / Mobile</label>
					<div class="field checking check">
						<i class="fa fa-phone icon-left"></i>
						<input type="text" name="phone" id="phone" placeholder="Phone number">
					</div>
				</div>
			</div>
			<!-- end email phone -->

			<div class="hr"></div>

			<!-- start email phone-->
			<div class="b-row">
				<div class="span6">
					<label class="label">About how many people?</label>
					<div class="field checking check">
						<i class="fa fa-male icon-left"></i>
						<input type="text" name="adults" placeholder="Number of guests">
					</div>
				</div>
				<div class="span6">
					<label class="label">Date</label>
					<div class="field checking check">
						<i class="fa fa-calendar icon-left"></i>
						<input type="text" id="popup-from" name="date-from" placeholder="dd-mm-yyyy" readonly>
					</div>
				</div>
			</div>
			<!-- end email phone -->

			

			<div class="hr"></div>

			<!-- start message -->
			<div class="b-row">
				<div class="span12">
					<label class="label">Comments</label>
					<div class="field checking check">
						<i class="fa fa-file-text-o icon-left"></i>
						<textarea name="message" placeholder="Your questions and comments..." spellcheck="false"></textarea>
					</div>
				</div>
			</div>
			<!-- end message -->

			<!-- start progress bar -->
			<div class="b-row">
				<span class="bar"></span>
			</div>
			<!-- end progress bar -->

			<div class="hr"></div>

			<!-- start buttons -->
			<div class="b-row">
				<div class="offset6 span3">
					<button type="submit" class="button" id="submit">Request</button>
				</div>
				<div class="span3">
					<button class="reset-button" id="reset-button">Reset</button>
				</div>
			</div>
			<!-- end buttons -->
		</form>
	</div>
</body>
</html>