<?php

/******************************************************/
/* Validation methods */
/******************************************************/
	/* Name */
	function validateName($name, $min_length) {
		$error_text = "Enter your name<br>";
		$len = mb_strlen($name, 'UTF-8');
		return ($len < $min_length) ? $error_text : "valid";
	}

	/* Email */
	function validateEmail($email){
		$error_text = "Incorrect email format<br>";
		$email_template = "/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/";
		return (preg_match($email_template, $email) !== 1) ? $error_text : "valid";
	}

	/* Phone */
	function validatePhone($phone) {
		$error_text = "Only digits.<br>";
		
		return (preg_match($phone_template, $phone) !== 1) ? $error_text : "valid";
	}

	/* Adult guests */
	function validateAdults($item) {
		$error_text = "Only integer numbers allowed<br>";
		$item_template = "/^[0-9]+$/";
		return (preg_match($item_template, $item) !== 1) ? $error_text : "valid";
	}

	/* Children guests */
	function validateChildren($item) {
		$error_text = "Only integer numbers allowed<br>";
		$item_template = "/^[0-9]+$/";
		return (preg_match($item_template, $item) !== 1) ? $error_text : "valid";
	}

	/* Date from */
	function validateDateFrom($date_from, $min_length) {
		$error_text = "Select start date<br>";
		$len = mb_strlen($date_from, 'UTF-8');
		return ($len < $min_length) ? $error_text : "valid";
	}

	/* Date to */
	function validateDateTo($date_to, $min_length) {
		$error_text = "Select finish date<br>";
		$len = mb_strlen($date_to, 'UTF-8');
		return ($len < $min_length) ? $error_text : "valid";
	}

	/* Message */
	function validateMessage($message, $min_length) {
		$error_text = "The message is too short - min 10 characters<br>";
		$len = mb_strlen($message, 'UTF-8');
		return ($len < $min_length) ? $error_text : "valid";
	}
?>