<?php
	header("Content-Type: text/html; charset=utf-8");

	if (!$_POST) exit;

	require dirname(__FILE__)."/validation.php";
	require dirname(__FILE__)."/csrf.php";

/************************************************/
/* Your data */
/************************************************/
	/* Your email goes here */
	$your_email = "reservation@restaurantsuhring.com ";

	/* Your name or your company name goes here */
	$your_name = "Sühring“;

	/* Message subject */
	$your_subject = „Reservation Request Website";

/************************************************/
/* Settings */
/************************************************/
	/* Select validation for fields */
	/* If you want to validate field - true, if you don't - false */
	$validate_name		= true;
	$validate_email		= true;
	$validate_phone		= false;
	$validate_adults	= true;
	$validate_date_from	= true;
	
	$validate_message	= true;

	/* Select the action */
	/* If you want to do the action - true, if you don't - false */
	$send_letter = true;

/************************************************/
/* Variables */
/************************************************/
	/* Error variables */
	$error_exist = false;
	$error_mail	 = array();
	$error_text	 = array();

	/* Success variables */
	$success_text = array("Your inquiry has been successfully sent");

	/* POST data */
	$name		= (isset($_POST["name"]))			? strip_tags(trim($_POST["name"]))			 : false;
	$email		= (isset($_POST["email"]))			? strip_tags(trim($_POST["email"]))			 : false;
	$phone		= (isset($_POST["phone"]))			? strip_tags(trim($_POST["phone"]))			 : false;
	$message	= (isset($_POST["message"]))		? strip_tags(trim($_POST["message"]))		 : false;
	$date_from	= (isset($_POST["date-from"]))		? strip_tags(trim($_POST["date-from"]))		 : false;
	$date_to	= (isset($_POST["date-to"]))		? strip_tags(trim($_POST["date-to"]))		 : false;
	$adults		= (isset($_POST["adults"]))			? strip_tags(trim($_POST["adults"]))		 : false;
	$children	= (isset($_POST["children"]))		? strip_tags(trim($_POST["children"]))		 : false;
	$token		= (isset($_POST["token_booking"])) 	? strip_tags(trim($_POST["token_booking"]))  : false;

	$name		= htmlspecialchars($name, ENT_QUOTES, 'UTF-8');
	$email		= htmlspecialchars($email, ENT_QUOTES, 'UTF-8');
	$phone		= htmlspecialchars($phone, ENT_QUOTES, 'UTF-8');
	$message	= htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
	$date_from	= htmlspecialchars($date_from, ENT_QUOTES, 'UTF-8');
	$date_to	= htmlspecialchars($date_to, ENT_QUOTES, 'UTF-8');
	$adults		= htmlspecialchars($adults, ENT_QUOTES, 'UTF-8');
	$children	= htmlspecialchars($children, ENT_QUOTES, 'UTF-8');
	$token		= htmlspecialchars($token, ENT_QUOTES, 'UTF-8');

	$name		= substr($name, 0, 30);
	$email		= substr($email, 0, 30);
	$phone		= substr($phone, 0, 30);
	$message	= substr($message, 0, 1500);
	$date_from	= substr($date_from, 0, 20);
	$date_to	= substr($date_to, 0, 20);
	$adults		= substr($adults, 0, 3);
	$children	= substr($children, 0, 3);

/************************************************/
/* CSRF protection */
/************************************************/
	$new_token = new CSRF('booking');
	if (!$new_token->check_token($token)) {
		$error_message = json_encode(array("errorToken" => "Incorrect token. Please reload this webpage"));
		echo $error_message;
		exit();
	}

/************************************************/
/* Validation */
/************************************************/
	/* Name */
	if ($validate_name){
		$error_text[] = validateName($name, 1);
	} else {
		$error_text[] = "valid";
	}

	/* Email */
	if ($validate_email){
		$error_text[] = validateEmail($email);
	} else {
		$error_text[] = "valid";
	}

	/* Phone */
	if ($validate_phone){
		$error_text[] = validatePhone($phone);
	} else {
		$error_text[] = "valid";
	}

	/* Adult guests */
	if ($validate_adults){
		$error_text[] = validateAdults($adults);
	} else {
		$error_text[] = "valid";
	}

	

	/* Date from */
	if ($validate_date_from){
		$error_text[] = validateDateFrom($date_from, 1);
	} else {
		$error_text[] = "valid";
	}

	
	/* Message */
	if ($validate_message){
		$error_text[] = validateMessage($message, 10);
	} else {
		$error_text[] = "valid";
	}

	foreach ($error_text as $value) {
		if ($value !== "valid"){
			$error_exist = true;
		}
	}

	/* If validation error occurs */
	if ($error_exist) {
		$error_message = json_encode(array("errorMessage" => $error_text));
		echo $error_message;
		exit();
	}

/************************************************/
/* Processing */
/************************************************/
	/* Send a letter */
	if ($send_letter) {
		require dirname(__FILE__)."/phpmailer/PHPMailerAutoload.php";
		require dirname(__FILE__)."/message.php";
		$mail = new PHPMailer;
		$mail->isSendmail();
		$mail->IsHTML(true);
		$mail->From = $email;
		$mail->CharSet = "UTF-8";
		$mail->FromName = "Event Inquiry Website";
		$mail->Encoding = "base64";
		$mail->ContentType = "text/html";
		$mail->addAddress($your_email, $your_name);
		$mail->Subject = $your_subject;
		$mail->Body = $letter;
		$mail->AltBody = "Use an HTML compatible email client";

		/* Multiple email recepients */
		/* If you want to add multiple email recepients - true, if you don't - false */
		/* Enter email and name of the recipients */
		$recipients = false;
		if ($recipients) {
			$recipients = array("email@domain.com" => "name of recipient",
								"email@domain.com" => "name of recipient",
								"email@domain.com" => "name of recipient"
								);
			foreach ($recipients as $email => $name) {
				$mail->AddBCC($email, $name);
			}
		}

		// if error occurs
		if(!$mail->send()) {
			$error_mail[] = "Mailer Error: " . $mail->ErrorInfo;
			$error_message = json_encode(array("errorMail" => $error_mail));
			echo $error_message;
			exit();
		}
	} // end $send_letter

	/* Success message */
	$success_message = json_encode(array("successMessage" => $success_text));
	echo $success_message;
?>